/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item.itemblock;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.block.BlockBase;
import com.raoulvdberge.refinedstorage.block.BlockPortableGrid;
import com.raoulvdberge.refinedstorage.item.ItemWirelessGrid;
import com.raoulvdberge.refinedstorage.item.itemblock.ItemBlockEnergyItem;
import com.raoulvdberge.refinedstorage.tile.grid.portable.PortableGrid;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBlockPortableGrid
extends ItemBlockEnergyItem {
    public ItemBlockPortableGrid(BlockPortableGrid block) {
        super((BlockBase)block, RS.INSTANCE.config.portableGridCapacity);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            API.instance().getGridManager().openGrid(PortableGrid.ID, (EntityPlayerMP)player, stack, player.field_71071_by.field_70461_c);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(I18n.func_135052_a((String)"block.refinedstorage:portable_grid.tooltip", (Object[])new Object[0]));
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public int getEntityLifespan(@Nonnull ItemStack stack, @Nonnull World world) {
        return Integer.MAX_VALUE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() == newStack.func_77973_b() && ItemWirelessGrid.getSortingDirection(oldStack) == ItemWirelessGrid.getSortingDirection(newStack) && ItemWirelessGrid.getSortingType(oldStack) == ItemWirelessGrid.getSortingType(newStack) && ItemWirelessGrid.getSearchBoxMode(oldStack) == ItemWirelessGrid.getSearchBoxMode(newStack) && ItemWirelessGrid.getTabSelected(oldStack) == ItemWirelessGrid.getTabSelected(newStack) && ItemWirelessGrid.getTabPage(oldStack) == ItemWirelessGrid.getTabPage(newStack) && ItemWirelessGrid.getSize(oldStack) == ItemWirelessGrid.getSize(newStack)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }
}

